#pragma once
#include <windows.h>
#include "../VM/scriptHeaders.h"
#include "../VM/opcodes.h"
#include "../VM/FunctionInstance.h"
#include "../VM/list.h"
#include "../VM/interfaces.h"
#include "../VM/manager.h"
#include "../VM/stack.h"

namespace Debugger1
{
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Text;

	/// <summary> 
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class Form1 : public System::Windows::Forms::Form
	{	
	public:
		Form1(void)
		{
			InitializeComponent();
		}
  
	protected:
		void Dispose(Boolean disposing)
		{
			if (theScript)
			{
				theScript->Release();
				theScript = NULL;
			}

			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		IScript*			theScript;				//rozhrani pro praci se skriptem
		static ListView*	m_pStack;				
		ListViewItem*		m_CurrInstruction;		//ukazatel na polozku v seznamu ktera predstavuje aktualni instrukci
													//instrukci ktera se provede po stisku klavesy pro krokovani programu

	private: System::Windows::Forms::MainMenu *  mainMenu1;
	private: System::Windows::Forms::MenuItem *  mnuScript;
	private: System::Windows::Forms::MenuItem *  mnuScriptLoad;

	private: System::Windows::Forms::MenuItem *  mnuDebug;
	private: System::Windows::Forms::MenuItem *  mnuDebugRun;
	private: System::Windows::Forms::MenuItem *  mnuDebugStep;
	private: System::Windows::Forms::OpenFileDialog *  openFileDialog1;

	private: System::Windows::Forms::ListView *  lstStack;
	private: System::Windows::Forms::ColumnHeader *  clmnIndex;
	private: System::Windows::Forms::ColumnHeader *  clmnValue;
	private: System::Windows::Forms::ListView *  lstscript;
	private: System::Windows::Forms::ColumnHeader *  clmnInstruction;
	private: System::Windows::Forms::Label *  lblStack;
	private: System::Windows::Forms::ListView *  lstct;
	private: System::Windows::Forms::ColumnHeader *  columnHeader1;
	private: System::Windows::Forms::ColumnHeader *  columnHeader2;
	private: System::Windows::Forms::Label *  lblct;
	private: System::Windows::Forms::ColumnHeader *  clmnadress;
	private: System::Windows::Forms::ColumnHeader *  clmnInstructionSize;
	private: System::Windows::Forms::MenuItem *  mnudebugStop;
	private: System::Windows::Forms::ListView *  lstFunctions;
	private: System::Windows::Forms::ColumnHeader *  columnHeader3;
	private: System::Windows::Forms::ColumnHeader *  columnHeader4;
	private: System::Windows::Forms::Label *  lblFunctions;
	private: System::Windows::Forms::ColumnHeader *  columnHeader5;
	private: System::Windows::Forms::ColumnHeader *  clmnO1;
	private: System::Windows::Forms::ColumnHeader *  clmnO2;
	private: System::Windows::Forms::Label *  lblPCs;
	private: System::Windows::Forms::Label *  lblPCd;
	private: System::Windows::Forms::Label *  lblSPd;
	private: System::Windows::Forms::Label *  lblSPs;
	private: System::Windows::Forms::Label *  lblBSPd;
	private: System::Windows::Forms::Label *  lblBSPs;
	private: System::Windows::Forms::MenuItem *  mnudebugRestart;





		System::ComponentModel::Container * components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->mainMenu1 = new System::Windows::Forms::MainMenu();
			this->mnuScript = new System::Windows::Forms::MenuItem();
			this->mnuScriptLoad = new System::Windows::Forms::MenuItem();
			this->mnuDebug = new System::Windows::Forms::MenuItem();
			this->mnuDebugRun = new System::Windows::Forms::MenuItem();
			this->mnuDebugStep = new System::Windows::Forms::MenuItem();
			this->mnudebugStop = new System::Windows::Forms::MenuItem();
			this->openFileDialog1 = new System::Windows::Forms::OpenFileDialog();
			this->lstStack = new System::Windows::Forms::ListView();
			this->clmnIndex = new System::Windows::Forms::ColumnHeader();
			this->clmnValue = new System::Windows::Forms::ColumnHeader();
			this->lstscript = new System::Windows::Forms::ListView();
			this->clmnadress = new System::Windows::Forms::ColumnHeader();
			this->clmnInstruction = new System::Windows::Forms::ColumnHeader();
			this->clmnO1 = new System::Windows::Forms::ColumnHeader();
			this->clmnO2 = new System::Windows::Forms::ColumnHeader();
			this->clmnInstructionSize = new System::Windows::Forms::ColumnHeader();
			this->lblStack = new System::Windows::Forms::Label();
			this->lstct = new System::Windows::Forms::ListView();
			this->columnHeader1 = new System::Windows::Forms::ColumnHeader();
			this->columnHeader2 = new System::Windows::Forms::ColumnHeader();
			this->lblct = new System::Windows::Forms::Label();
			this->lstFunctions = new System::Windows::Forms::ListView();
			this->columnHeader3 = new System::Windows::Forms::ColumnHeader();
			this->columnHeader4 = new System::Windows::Forms::ColumnHeader();
			this->columnHeader5 = new System::Windows::Forms::ColumnHeader();
			this->lblFunctions = new System::Windows::Forms::Label();
			this->lblPCs = new System::Windows::Forms::Label();
			this->lblPCd = new System::Windows::Forms::Label();
			this->lblSPd = new System::Windows::Forms::Label();
			this->lblSPs = new System::Windows::Forms::Label();
			this->lblBSPd = new System::Windows::Forms::Label();
			this->lblBSPs = new System::Windows::Forms::Label();
			this->mnudebugRestart = new System::Windows::Forms::MenuItem();
			this->SuspendLayout();
			// 
			// mainMenu1
			// 
			System::Windows::Forms::MenuItem* __mcTemp__1[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__1[0] = this->mnuScript;
			__mcTemp__1[1] = this->mnuDebug;
			this->mainMenu1->MenuItems->AddRange(__mcTemp__1);
			// 
			// mnuScript
			// 
			this->mnuScript->Index = 0;
			System::Windows::Forms::MenuItem* __mcTemp__2[] = new System::Windows::Forms::MenuItem*[1];
			__mcTemp__2[0] = this->mnuScriptLoad;
			this->mnuScript->MenuItems->AddRange(__mcTemp__2);
			this->mnuScript->Text = S"Script";
			// 
			// mnuScriptLoad
			// 
			this->mnuScriptLoad->Index = 0;
			this->mnuScriptLoad->Text = S"Load...";
			this->mnuScriptLoad->Click += new System::EventHandler(this, mnuScriptLoad_Click);
			// 
			// mnuDebug
			// 
			this->mnuDebug->Index = 1;
			System::Windows::Forms::MenuItem* __mcTemp__3[] = new System::Windows::Forms::MenuItem*[4];
			__mcTemp__3[0] = this->mnuDebugRun;
			__mcTemp__3[1] = this->mnuDebugStep;
			__mcTemp__3[2] = this->mnudebugStop;
			__mcTemp__3[3] = this->mnudebugRestart;
			this->mnuDebug->MenuItems->AddRange(__mcTemp__3);
			this->mnuDebug->Text = S"Debug";
			// 
			// mnuDebugRun
			// 
			this->mnuDebugRun->Index = 0;
			this->mnuDebugRun->Shortcut = System::Windows::Forms::Shortcut::F5;
			this->mnuDebugRun->Text = S"Run";
			this->mnuDebugRun->Click += new System::EventHandler(this, mnuDebugRun_Click);
			// 
			// mnuDebugStep
			// 
			this->mnuDebugStep->Index = 1;
			this->mnuDebugStep->Shortcut = System::Windows::Forms::Shortcut::F10;
			this->mnuDebugStep->Text = S"Step";
			this->mnuDebugStep->Click += new System::EventHandler(this, mnuDebugStep_Click);
			// 
			// mnudebugStop
			// 
			this->mnudebugStop->Index = 2;
			this->mnudebugStop->Text = S"Stop";
			this->mnudebugStop->Click += new System::EventHandler(this, mnudebugStop_Click);
			// 
			// lstStack
			// 
			this->lstStack->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			System::Windows::Forms::ColumnHeader* __mcTemp__4[] = new System::Windows::Forms::ColumnHeader*[2];
			__mcTemp__4[0] = this->clmnIndex;
			__mcTemp__4[1] = this->clmnValue;
			this->lstStack->Columns->AddRange(__mcTemp__4);
			this->lstStack->Location = System::Drawing::Point(392, 376);
			this->lstStack->Name = S"lstStack";
			this->lstStack->Size = System::Drawing::Size(360, 96);
			this->lstStack->TabIndex = 1;
			this->lstStack->View = System::Windows::Forms::View::Details;
			// 
			// clmnIndex
			// 
			this->clmnIndex->Text = S"Index";
			// 
			// clmnValue
			// 
			this->clmnValue->Text = S"Value";
			this->clmnValue->Width = 200;
			// 
			// lstscript
			// 
			System::Windows::Forms::ColumnHeader* __mcTemp__5[] = new System::Windows::Forms::ColumnHeader*[5];
			__mcTemp__5[0] = this->clmnadress;
			__mcTemp__5[1] = this->clmnInstruction;
			__mcTemp__5[2] = this->clmnO1;
			__mcTemp__5[3] = this->clmnO2;
			__mcTemp__5[4] = this->clmnInstructionSize;
			this->lstscript->Columns->AddRange(__mcTemp__5);
			this->lstscript->Font = new System::Drawing::Font(S"Courier New", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lstscript->ForeColor = System::Drawing::Color::Green;
			this->lstscript->Location = System::Drawing::Point(8, 8);
			this->lstscript->Name = S"lstscript";
			this->lstscript->Size = System::Drawing::Size(376, 464);
			this->lstscript->TabIndex = 2;
			this->lstscript->View = System::Windows::Forms::View::Details;
			// 
			// clmnadress
			// 
			this->clmnadress->Text = S"Adress";
			// 
			// clmnInstruction
			// 
			this->clmnInstruction->Text = S"Instruction";
			this->clmnInstruction->Width = 100;
			// 
			// clmnO1
			// 
			this->clmnO1->Text = S"O1";
			this->clmnO1->Width = 50;
			// 
			// clmnO2
			// 
			this->clmnO2->Text = S"O2";
			this->clmnO2->Width = 50;
			// 
			// clmnInstructionSize
			// 
			this->clmnInstructionSize->Text = S"Instruction Size:";
			this->clmnInstructionSize->Width = 150;
			// 
			// lblStack
			// 
			this->lblStack->Location = System::Drawing::Point(392, 352);
			this->lblStack->Name = S"lblStack";
			this->lblStack->Size = System::Drawing::Size(360, 16);
			this->lblStack->TabIndex = 3;
			this->lblStack->Text = S"Stack:";
			// 
			// lstct
			// 
			this->lstct->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			System::Windows::Forms::ColumnHeader* __mcTemp__6[] = new System::Windows::Forms::ColumnHeader*[2];
			__mcTemp__6[0] = this->columnHeader1;
			__mcTemp__6[1] = this->columnHeader2;
			this->lstct->Columns->AddRange(__mcTemp__6);
			this->lstct->Location = System::Drawing::Point(392, 248);
			this->lstct->Name = S"lstct";
			this->lstct->Size = System::Drawing::Size(360, 96);
			this->lstct->TabIndex = 4;
			this->lstct->View = System::Windows::Forms::View::Details;
			// 
			// columnHeader1
			// 
			this->columnHeader1->Text = S"Index";
			// 
			// columnHeader2
			// 
			this->columnHeader2->Text = S"Value";
			this->columnHeader2->Width = 200;
			// 
			// lblct
			// 
			this->lblct->Location = System::Drawing::Point(392, 224);
			this->lblct->Name = S"lblct";
			this->lblct->Size = System::Drawing::Size(360, 16);
			this->lblct->TabIndex = 5;
			this->lblct->Text = S"Constant Table:";
			// 
			// lstFunctions
			// 
			this->lstFunctions->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			System::Windows::Forms::ColumnHeader* __mcTemp__7[] = new System::Windows::Forms::ColumnHeader*[3];
			__mcTemp__7[0] = this->columnHeader3;
			__mcTemp__7[1] = this->columnHeader4;
			__mcTemp__7[2] = this->columnHeader5;
			this->lstFunctions->Columns->AddRange(__mcTemp__7);
			this->lstFunctions->Location = System::Drawing::Point(392, 112);
			this->lstFunctions->Name = S"lstFunctions";
			this->lstFunctions->Size = System::Drawing::Size(360, 96);
			this->lstFunctions->TabIndex = 6;
			this->lstFunctions->View = System::Windows::Forms::View::Details;
			// 
			// columnHeader3
			// 
			this->columnHeader3->Text = S"Name:";
			this->columnHeader3->Width = 200;
			// 
			// columnHeader4
			// 
			this->columnHeader4->Text = S"Start Code:";
			this->columnHeader4->Width = 70;
			// 
			// columnHeader5
			// 
			this->columnHeader5->Text = S"End Code:";
			this->columnHeader5->Width = 70;
			// 
			// lblFunctions
			// 
			this->lblFunctions->Location = System::Drawing::Point(392, 88);
			this->lblFunctions->Name = S"lblFunctions";
			this->lblFunctions->Size = System::Drawing::Size(360, 16);
			this->lblFunctions->TabIndex = 7;
			this->lblFunctions->Text = S"Functions:";
			// 
			// lblPCs
			// 
			this->lblPCs->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblPCs->Location = System::Drawing::Point(400, 16);
			this->lblPCs->Name = S"lblPCs";
			this->lblPCs->Size = System::Drawing::Size(48, 16);
			this->lblPCs->TabIndex = 8;
			this->lblPCs->Text = S"PC:";
			// 
			// lblPCd
			// 
			this->lblPCd->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblPCd->Location = System::Drawing::Point(448, 16);
			this->lblPCd->Name = S"lblPCd";
			this->lblPCd->Size = System::Drawing::Size(48, 16);
			this->lblPCd->TabIndex = 9;
			this->lblPCd->Text = S"0";
			// 
			// lblSPd
			// 
			this->lblSPd->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblSPd->Location = System::Drawing::Point(448, 40);
			this->lblSPd->Name = S"lblSPd";
			this->lblSPd->Size = System::Drawing::Size(48, 16);
			this->lblSPd->TabIndex = 11;
			this->lblSPd->Text = S"0";
			// 
			// lblSPs
			// 
			this->lblSPs->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblSPs->Location = System::Drawing::Point(400, 40);
			this->lblSPs->Name = S"lblSPs";
			this->lblSPs->Size = System::Drawing::Size(48, 16);
			this->lblSPs->TabIndex = 10;
			this->lblSPs->Text = S"SP:";
			// 
			// lblBSPd
			// 
			this->lblBSPd->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblBSPd->Location = System::Drawing::Point(448, 64);
			this->lblBSPd->Name = S"lblBSPd";
			this->lblBSPd->Size = System::Drawing::Size(48, 16);
			this->lblBSPd->TabIndex = 13;
			this->lblBSPd->Text = S"0";
			// 
			// lblBSPs
			// 
			this->lblBSPs->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 8.25F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)238);
			this->lblBSPs->Location = System::Drawing::Point(400, 64);
			this->lblBSPs->Name = S"lblBSPs";
			this->lblBSPs->Size = System::Drawing::Size(48, 16);
			this->lblBSPs->TabIndex = 12;
			this->lblBSPs->Text = S"BSP:";
			// 
			// mnudebugRestart
			// 
			this->mnudebugRestart->Index = 3;
			this->mnudebugRestart->Text = S"Restart";
			this->mnudebugRestart->Click += new System::EventHandler(this, mnudebugRestart_Click);
			// 
			// Form1
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(760, 481);
			this->Controls->Add(this->lblBSPd);
			this->Controls->Add(this->lblBSPs);
			this->Controls->Add(this->lblSPd);
			this->Controls->Add(this->lblSPs);
			this->Controls->Add(this->lblPCd);
			this->Controls->Add(this->lblPCs);
			this->Controls->Add(this->lblFunctions);
			this->Controls->Add(this->lstFunctions);
			this->Controls->Add(this->lblct);
			this->Controls->Add(this->lstct);
			this->Controls->Add(this->lblStack);
			this->Controls->Add(this->lstscript);
			this->Controls->Add(this->lstStack);
			this->Menu = this->mainMenu1;
			this->Name = S"Form1";
			this->Text = S"Universal Script Debugger";
			this->Load += new System::EventHandler(this, Form1_Load);
			this->ResumeLayout(false);

		}	

//****************************************************************************************************************
//Nacteni okna
//****************************************************************************************************************
	private: System::Void Form1_Load(System::Object *  sender, System::EventArgs *  e)
			 {
				 //takova mala objizdka, z nejakeho duvodu to nelze zkompilovat pokud je druhy
				 //parametr fce CreateVMObject primo ukazatel na rozhrani IScript* theScript, takye
				 //to musim takhle obejit pomoci ukazatele na void
				 void* tmpPtr = NULL;

				 //zeptame se na royhrani pro praci se skriptem
				 if (FAILED(CreateVMObject(IID_IScript,(void**)&tmpPtr)))
				 {
					 //tohle by se prakticky nemelo stat
					 MessageBox(NULL,"Initialization Failed! Failed to retrieve pointer on script interface!","Error",MB_OK | MB_ICONERROR);
					 exit(0);
				 }
				
				 //ulozime ukazatel do spravne promenne
				 theScript = (IScript*)tmpPtr;

				 m_pStack = lstStack;
			 }
//****************************************************************************************************************
//spusteni prikazu pro provedeni skriptu
//****************************************************************************************************************
	private: System::Void mnuDebugRun_Click(System::Object *  sender, System::EventArgs *  e)
			 {
				 theScript->Stop();		
				 theScript->StartMain();
				 theScript->HandleScripts(0);
			 }
//****************************************************************************************************************
//prikaz pro nacteni skriptu
//****************************************************************************************************************
private: System::Void mnuScriptLoad_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 //nastaveni filtru souboru
			 openFileDialog1->Filter = "Script binary|*.usb";
			 openFileDialog1->Title = "Load Script";
			 
			 //ted budeme pokracovat pokud uzivatel na dialogu neyvoli storno
			 if (openFileDialog1->ShowDialog() == DialogResult::OK)
			 {
				 //potrebujeme jmeno souboru jako pole znaku, ne jako _gc string, konverze
				 char* scriptName = ConvertStringToCharArray(openFileDialog1->FileName);
				 
				 //nacteni skriptu rozhranim pro praci se skripty a informovani o neuspechu v pripade potreby
				 if (FAILED(theScript->LoadScript(scriptName)))
				 {
					 MessageBox(NULL,"Failed to load script! See debug file for details!","Error",MB_OK);
					 return;
				 }

				 //dekompilace kodoveho segmentu do podoby instrukci, abychom videli jak program vypada
				 //nebude to sice vzssi jazyk, jen assembler skriptu, ale aspon neco uvidime
				 DecompileCodeSegment();
					
				 //inicializce tabulky konstant, abychom videli co v ni je a kde
				 InitConstantTable();
				 //inicializace tabulky funkci ktere skript obsahuje
				 InitFunctions();
				 //inicializace zasobniku na kterem se pocita, bude v nem pri krokovani programu videt co se deje
				 InitStack();

				 //tento radek v seznamu instrukci zvyrazni misto kde je prvni instrukce funkce main, ta je automaticky spustena
				 //pri nacteni skriptu, respektive je umistena do zasobniku funkci ktere se maji provest
				 m_CurrInstruction = lstscript->Items->Item[FindCode(Convert::ToInt32(theScript->GetCurrFunction()->GetPC()),0,lstscript->Items->Count - 1)];
				 //nastaveni barvy polozky ktera predstavuje instrukci na zlutou
				 m_CurrInstruction->BackColor = Color::Yellow;
				 //vypis obsahu citace instrukci a ukazatelu do zasobnikuna obrazovku do prislusejicich popisku
				 lblPCd->Text = theScript->GetCurrFunction()->GetPC().ToString();
				 lblSPd->Text = theScript->GetCurrFunction()->GetSP().ToString();
				 lblBSPd->Text = theScript->GetCurrFunction()->GetBSP().ToString();
			 }
		 }
//****************************************************************************************************************
//prevedeni _gc string do pole znaku
//****************************************************************************************************************
		public: char*	ConvertStringToCharArray(System::String* pString)
		{			
			Encoding* pEnc = Encoding::Default;
			Byte pBytes[] = pEnc->GetBytes(pString);

			char* pBuffer = new char[pBytes->Length + 1];
			for (System::UInt32 i = 0; i < pBytes->Length; i++)
				pBuffer[i] = pBytes[i];
			
			pBuffer[pBytes->Length] = 0;

			return pBuffer;
		}
//****************************************************************************************************************
//Dekompilace kodoveho segmentu
//****************************************************************************************************************
        void	DecompileCodeSegment()
		{
			//V celku se nejedna o nic sloziteho, jen ziskame ukazatel na kodovy segment a cteme bytove kody
			//instrukci. Podle kodu se rozhodneme o jakou instrukci jde  a vypiseme do seznamu jeji offset v kodovem segmentu,
			//nazev, operand 1, operand 2 a velikost instrukce, takze je to jenom o velkem poctu case vetvi, jedna pro kazdy
			//byte kod
			unsigned char* pCodeSegment = NULL;
			unsigned char* pCodeSegmentStart = NULL;
			unsigned int adress = 0;
			unsigned short index = 0;
			unsigned short code_offset = 0;
			ListViewItem* pNewItem = NULL;

			if (!theScript)
				return;

			int code_size = theScript->GetCodeSegmentSize();
			pCodeSegmentStart = pCodeSegment = theScript->GetCodeSegment();

			while ((code_offset = (pCodeSegment - pCodeSegmentStart)) != code_size)
			{
				unsigned char opcode = *(pCodeSegment++);

				switch (opcode)
				{
				case nopCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_nop));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case mulCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_mul));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case negCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_neg));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case modCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_mod));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case subCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_sub));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case divCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_div));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case addCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_add));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case lgotoCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_lgoto));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case ifeqCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ifeq));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case ifneCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ifne));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case if_cmpeqCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmpeq));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;				
				case if_cmpltCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmplt));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;				
				case if_cmpleCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmple));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case if_cmpgeCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmpge));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case if_cmpgtCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmpgt));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case if_cmpneCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_if_cmpne));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case nreturnCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_nreturn));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case loadCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					index = *((unsigned short*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned short);
					pNewItem->SubItems->Add(Convert::ToString(instruction_load));
					pNewItem->SubItems->Add(index.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned short)));
					break;
				case storeCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					index = *((unsigned short*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned short);
					pNewItem->SubItems->Add(Convert::ToString(instruction_store));
					pNewItem->SubItems->Add(index.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned short)));
					break;
				case ldc_intCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ldc_int));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case ldc_stringCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ldc_string));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");					
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case ldc_doubleCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ldc_double));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case dupCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_dup));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case popCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_pop));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case lcallCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					pNewItem->SubItems->Add(Convert::ToString(instruction_lcall));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int)));
					break;
				case ecallCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					adress = *((unsigned int*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned int);
					index = *((unsigned short*)(pCodeSegment));
					pCodeSegment += sizeof(unsigned short);
					pNewItem->SubItems->Add(Convert::ToString(instruction_ecall));
					pNewItem->SubItems->Add(adress.ToString());
					pNewItem->SubItems->Add(index.ToString());
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char) + sizeof(unsigned int) + sizeof(unsigned short)));
					break;
				case vreturnCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_vreturn));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case shlCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_shl));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case shrCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_shr));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case incCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					lstscript->Items->Add(Convert::ToString(instruction_inc));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case decCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_dec));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case orCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_or));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				case andCI:
					pNewItem = lstscript->Items->Add(code_offset.ToString());
					pNewItem->SubItems->Add(Convert::ToString(instruction_and));
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add("N/A");
					pNewItem->SubItems->Add(Convert::ToString(sizeof(unsigned char)));
					break;
				}
			}
		}
//****************************************************************************************************************
//inicializace zasobniku a nastaveni vsech hodnot na nula
//****************************************************************************************************************
		void	InitStack()
		{
			//nejdriv zasobnik cely vymazeme
			lstStack->Items->Clear();

			//potom do nej pridame vsechny polozky a nastavime je na 0
			for (unsigned int i = 0; i < MAX_STACK_SIZE; i++)
			{
				lstStack->Items->Add(i.ToString());
				lstStack->Items->Item[i]->SubItems->Add("0");
			}
		}
//****************************************************************************************************************
//Inicializace tabulky symbolu
//****************************************************************************************************************
		 void	InitConstantTable()
		 {
			 //ziskame ukazatel na tabulku symbolu pomoci royhrani pro praci se skripty
			 //pak jen prochayime tuto tabulku a podle kazde polozky pridame prislusejici 
			 //informaci do seznamu konstant. V tabulce konstant muze byt integer, double nebo retezec ukonceny nulou
			 //proto ten switch v cyklu, musime se nejdriv podivat co je v dane polozce ulozeno
			 CStack<StackItem>*	ct = theScript->GetConstantTable();
			 unsigned int numconst = ct->Size();
			 StackItem* currItem;
			 ListViewItem* pNewItem = NULL;

			 for (unsigned int i = 0; i < numconst; i++)
			 {
				 currItem = &((*ct)[i]);
				
				 pNewItem = lstct->Items->Add(i.ToString());

				 switch (currItem->kind)
				 {
				 case INT_CONST:
					pNewItem->SubItems->Add(currItem->intval.ToString());
					break;
				 case DOUBLE_CONST:
					pNewItem->SubItems->Add(currItem->doubleval.ToString());
					break;
				 case ZSTRING_CONST:
					pNewItem->SubItems->Add(currItem->strval);
					break;
				 }
			 }
		 }
//****************************************************************************************************************
//inicializace tabulky funkci
//****************************************************************************************************************
		 void	InitFunctions()
		 {
			 //opet nejde o  nic sloziteho, jen ziskame ukazatel na tabulku funkci z rozhrani pro praci
			 //skripty a budeme seznamem prochazet. Do seznamu pridame z kazde polozky v tabulce jmeno funkce,
			 //a kde zacina a konci v kodovem segmentu
			 CList<FUNCTION_HEADER*>* pList = theScript->GetFunctionsList();
			 ListViewItem*	pNewItem = NULL;

			 for (unsigned int i = 0; i < pList->Size(); i++)
			 {
				 FUNCTION_HEADER* pFunc = (FUNCTION_HEADER*)(*pList)[i];
				 pNewItem = lstFunctions->Items->Add(pFunc->name);
				 pNewItem->SubItems->Add(pFunc->startCode.ToString());
				 pNewItem->SubItems->Add(pFunc->endCode.ToString());
			 }
		 }
//****************************************************************************************************************
//prikaz pro krokovani skriptu
//****************************************************************************************************************
		 private: System::Void mnuDebugStep_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 bool bnext = true;

			 
			 if (!(theScript->GetCurrFunction()))
			 {
				 mnuDebugStep->Enabled = false;
			 }

			 while (bnext)
				theScript->HandleScripts(1,&bnext);

			 if (theScript->GetCurrFunction())
			 {
				ProcessCode();
				lblPCd->Text = theScript->GetCurrFunction()->GetPC().ToString();
				lblSPd->Text = theScript->GetCurrFunction()->GetSP().ToString();
				lblBSPd->Text = theScript->GetCurrFunction()->GetBSP().ToString();
			 } 
		 }
//****************************************************************************************************************
//prikaz zastaveni skriptu
//****************************************************************************************************************
		private: System::Void mnudebugStop_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 m_CurrInstruction->BackColor = Color::White;
			 theScript->Stop();
		 }
//****************************************************************************************************************
//fce pro zpracovani kodu
//****************************************************************************************************************
		 void	ProcessCode()
		 {
			m_CurrInstruction->BackColor = Color::White;

			int o1 = 0;
			int o2 = 0;
			String* instruction = m_CurrInstruction->SubItems->Item[1]->Text; 
			ListViewItem* psitem = NULL;

			if (String::Compare(instruction,Convert::ToString(instruction_ldc_int)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
                psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_ldc_double)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
                psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_ldc_string)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
                psitem->SubItems->Item[1]->Text = pItem->strval;				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_load)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = Convert::ToInt32(m_CurrInstruction->SubItems->Item[2]->Text);
				int ibsp = theScript->GetCurrFunction()->GetBSP();
				StackItem* pItem = &((*pStack)[ibsp + o1]);
				o1 = theScript->GetCurrFunction()->GetSP();
				psitem = lstStack->Items->Item[o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_store)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				int ibsp = theScript->GetCurrFunction()->GetBSP();
				StackItem* pItem = &((*pStack)[o1]);
				o1 = Convert::ToInt32(m_CurrInstruction->SubItems->Item[2]->Text);
				psitem = lstStack->Items->Item[ibsp + o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_add)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_sub)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_mul)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_div)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				switch (pItem->kind)
				{
				case INT_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
					break;
				case DOUBLE_CONST:
					psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->doubleval);				
					break;
				case ZSTRING_CONST:
					psitem->SubItems->Item[1]->Text = pItem->strval;				
					break;
				}
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_mod)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_and)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_or)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_shl)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}
			else if (String::Compare(instruction,Convert::ToString(instruction_shr)) == 0)
			{
				CStack<StackItem>* pStack = theScript->GetCurrFunction()->GetStack();
				o1 = theScript->GetCurrFunction()->GetSP();
				StackItem* pItem = &((*pStack)[o1]);
				psitem = lstStack->Items->Item[o1];
				psitem->SubItems->Item[1]->Text = Convert::ToString(pItem->intval);				
			}


			m_CurrInstruction = lstscript->Items->Item[FindCode(Convert::ToInt32(theScript->GetCurrFunction()->GetPC()),0,lstscript->Items->Count - 1)];
			m_CurrInstruction->BackColor = Color::Yellow;
		 }

		 long	FindCode(int num,long left, long right)
		 {
			 long middle = (left + right) / 2;

			 ListViewItem* pItem = lstscript->Items->Item[middle];

			 int ln = Convert::ToInt32(pItem->Text);

			 if (num < ln)
				 return FindCode(num,left,middle-1);
			 if (num > ln)
				 return FindCode(num,middle+1,right);

			return middle;
		 }
//****************************************************************************************************************
//prikaz restartovani skriptu
//****************************************************************************************************************
private: System::Void mnudebugRestart_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 //nejdriv skript zastavime, pro pripad ze byl spusten
			 theScript->Stop();
			 //spustime hlavni funkci
			 theScript->StartMain();
			 
			 //zrusime zvyrazneni posledni provadene instrukce
			 m_CurrInstruction->BackColor = Color::White;
			 //najdeme instrukci na ktere se zacne
			 m_CurrInstruction = lstscript->Items->Item[FindCode(Convert::ToInt32(theScript->GetCurrFunction()->GetPC()),0,lstscript->Items->Count - 1)];
			 //zvyraznime polozku v seynamu predstavujici prvni instrukci ktera se provede
			 m_CurrInstruction->BackColor = Color::Yellow;	
			 //aktualizace popisku
			 lblPCd->Text = theScript->GetCurrFunction()->GetPC().ToString();
			 lblSPd->Text = theScript->GetCurrFunction()->GetSP().ToString();
			 lblBSPd->Text = theScript->GetCurrFunction()->GetBSP().ToString();

			 //povoliem opet krokovani
			 mnuDebugStep->Enabled = true;
		 }

};
}

